package abstraction;
/**
 * 
 * @author Chiara Coccia, Diego Colarullo
 * @version 1.5 09/03/18
 * @since JDK 1.6
 */
import java.util.*;

/**
 * 
 * This class executes carthisian product. To execute a product you have to call executeProduct methods
 */
public class CartesianProduct {

	long estimateTime;
	/**
	 * This method build a Carthisian Product among Services present inside a Community 
	 * @param comm where execute product
	 * @return a carthisian product like Service. Service Class wants a String with content's available service.
	 *         This string will be provide from productService method
	 */
	public static Service executeProduct(AvailableServices comm){
		
		AvailableServices community=(AvailableServices)comm.clone();
		
		String cartesianProductString = new String("");
		Iterator<Service> it= community.getIterator(); 
		
		if(community.sizeCommunity()==0)
			return null;
		
		if(community.sizeCommunity()>2){				
			    Service service1=it.next();
				Service service2=it.next();	
				cartesianProductString = productService(service1, service2);				
				Service service = new Service(cartesianProductString);			
				community.deleteService(community.getPosition(service1));
				community.deleteService(community.getPosition(service2));					
				it= community.getIterator(); 								
				
				while(it.hasNext()){						
					Service service3= it.next();	
					cartesianProductString= productService(service, service3);
					service = new Service(cartesianProductString);
					community.deleteService(community.getPosition(service3));									
					it= community.getIterator(); 							 
			}
		}
		else{
			if(community.sizeCommunity()==2){
					cartesianProductString=productService(it.next(),it.next());	
			}
			else{	
					Service serv=it.next();
					serv.setName("community");
					return serv;
					
			}			
		}
		return new Service(cartesianProductString);	
		}	
		
	/**
	 * This method builds a String with final states and transition of two Service.
	 * @param s1 service
	 * @param s2 service
	 * @return a service like a String     
	 */
	private static String productService(Service s1, Service s2){	   
		String finalState = productFinalStates(s1.getFinalStatesSet(),s2.getFinalStatesSet());
		finalState = "final:"+finalState.substring(0, finalState.lastIndexOf(";"))+".";
		String transaction = productTransition(s1.getTransitionFunctionsSet(),s1.getName(), s2.getTransitionFunctionsSet(), s2.getName());
		transaction = "transaction:"+transaction;										
		String initial = "initial:"+s1.getInitialState().getName()+""+s2.getInitialState().getName()+";";
		String serviceContent ="community?+"+transaction+initial+finalState;
		
		return serviceContent;
	}

	/**
	 * This method execute a carthisian product among transition functions
	 * @param l1 Set of transition functions of one Service of community
	 * @param l2 Set of transition functions of another Service of community
	 * @return a string with product of all transition functions
	 */
	private static String productTransition (Set<TransitionFunction> l1, String l1Name,Set<TransitionFunction> l2, String l2Name){
		
		String transaction="";
		Iterator<TransitionFunction> it = l1.iterator();				
		while(it.hasNext()){			
			TransitionFunction state1= it.next();
			Iterator<TransitionFunction> it2 = l2.iterator();		
			while(it2.hasNext()){
				TransitionFunction state2= it2.next();		
				String firstServiceAction;
				String secondServiceAction;
				
				if(state1.getAction().getName().contains(",")){
					firstServiceAction = state1.getAction().getName();
				}
				else
					firstServiceAction = state1.getAction().getName()+","+l1Name;
				
				
				secondServiceAction = state2.getAction().getName()+","+l2Name;
				
				//transition function has all combination that changes first service's states(present-next)
				//and mantains stopped present states of second service 
				transaction =transaction+state1.getPresentState()+""+state2.getPresentState()+"-"+firstServiceAction+"-"+
							 state1.getNextState()+""+state2.getPresentState()+";";	
				
				//transition function has all combination that changes first service's states(present-next)
				//and mantains stopped future states of second servcie 
				transaction =transaction+state1.getPresentState()+""+state2.getNextState()+"-"+firstServiceAction+"-"+
				 			 state1.getNextState()+""+state2.getNextState()+";";		
				
				//transition function has all combination that changes second service's states(present-next)
				//and mantains stopped present states of first service
				transaction =transaction+state1.getPresentState()+""+state2.getPresentState()+"-"+secondServiceAction+"-"+
				 			 state1.getPresentState()+""+state2.getNextState()+";";	
				
				//transition function has all combination that changes second service's states(present-next)
				//and mantains stopped future states of first servcie  
				transaction =transaction+state1.getNextState()+""+state2.getPresentState()+"-"+secondServiceAction+"-"+
				 			 state1.getNextState()+""+state2.getNextState()+";";
		    }
		}
	    return transaction;	    
	}	

	/**
	 * This method executes a Cartesian product among final states
	 * @param l1 Set of final states of one Service of community
	 * @param l2 Set of final states of another Service of community
	 * @return a string with product of all transition functions
	 */
	private static String productFinalStates (Set<State> l1, Set<State> l2){
		String prod = new String("");		
		Iterator<State> it = l1.iterator();				
		int i=0,j=0;
		while(it.hasNext()){
			i++;
			State final1= it.next();
			Iterator<State> it2 = l2.iterator();				
			while(it2.hasNext()){		
				j++;
				prod=prod+final1+""+it2.next()+";";	
		    }
		}
	    return prod;
	}

}

